const updateMessage = (id, message) => {
  document.getElementById(id).textContent = message;
};

const fetchConfig = async () => {
  try {
    const config = await window.Cortex.app.getConfig(); 
    const parameterValue = config.custom_parameter ? config.custom_parameter : 'no custom parameter found';
    const venueIdValue = config.venue_id ? config.venue_id : 'no venue_id found';
    updateMessage('custom_parameter', `custom_parameter: ${parameterValue}`);
    updateMessage('venue_id', `venue_id: ${venueIdValue}`);
  } catch (error) {
    updateMessage('custom_parameter', `custom_parameter: no custom parameter found`);
    updateMessage('venue_id', `venue_id: no venue_id found`);
  }
};

const initCreative = () => {
  window.addEventListener('cortex-ready', () => { //Listens for cortex-ready, which must fire before calling getConfig() to fetch parameters
    updateMessage('cortex-ready', 'cortex-ready: true');
    fetchConfig(); //Fetches parameters by calling the Cortex Player's getConfig function
  });

  window.addEventListener('cortex-visible', () => {
    updateMessage('cortex-visible', 'cortex-visible: true');
  });

  window.addEventListener('cortex-hidden', () => {
    updateMessage('cortex-hidden', 'cortex-hidden: true');
  });
};

document.onreadystatechange = () => {
  if (document.readyState === 'interactive') {
    initCreative();
  }
};
