# Introduction 
Cortex prepares creatives in the background before they appear on-screen. Therefore, dynamic creatives should start animations or unpause videos only when the Player indicates the creative is visible on-screen. These actions shouldn’t occur when the creative is initially prepared in the background. 

This sample dynamic creative has two versions of the index.html file. One version pauses a video when it’s first set up in the background and unpauses it when it appears on-screen. The other version starts an animation as soon as it becomes visible on-screen. 

This readme explains the method this sample dynamic creative uses for each version. For more information, see our knowledge base: https://help.vistarmedia.com/hc/en-us/articles/36006531110925-Building-dynamic-creatives-for-the-Cortex-Player

# Guidance for Video Dynamic Creatives
## Key Video Lifecycle:
### cortex-ready:
This event means the container is set up in the background but hasn’t appeared yet. It’s time to get the video ready to play.
Preparation steps could include:
-> Creating and setting up the <video> element.
-> Adding necessary video sources (e.g., .mp4, .webm).
-> Ensuring the video element is in a paused state and not playing.
The video will not start playing at this stage.
### cortex-visible:
This event triggers when the container appears on-screen. The video is now ready to play.
Start Video Playback: When the container appears, this event triggers the video to start playing. To do this, you’ll call video.play().
At this point, the video starts playing, respecting settings like autoplay or user controls.
### cortex-hidden:
This event signals the container is no longer visible. The content has already played for the set amount of time, like the ad duration.
Stop Video Playback: When the container becomes hidden, this is the signal to stop the video. You’ll do this by calling video.pause(). You can also reset the video to its beginning with video.currentTime = 0.
If the elements aren’t cleaned up, the dynamic creative’s div will disappear 500 milliseconds later.

# Guidance for Animation Dynamic Creatives
In this setup, animations work as part of the container or element’s lifecycle, similar to videos. The flow is managed by the cortex-ready, cortex-visible, and cortex-hidden events. Animations trigger when the container appears (cortex-visible) and stop or clean up when it disappears (cortex-hidden). You don’t need to manually set up these event listeners but it’s a good idea. This ensures animations start and stop in a way that aligns with the container’s visibility.
## Key Animation Lifecycle:
### cortex-ready:
This event signals that the container isn’t yet visible and prepares any necessary data or content. No animation takes place at this stage. It's simply a preparatory phase.
### cortex-visible:
This event indicates that the container is now visible on-screen. It’s ready for the animation to begin.
For any new animation: When this event triggers, the animation should start. Whether it’s the "box dropping" sample animation or any other animation, this is the point when the animation starts. The cortex-visible event is the cue to begin any animations tied to the container or its elements.
### cortex-hidden:
This event fires when the container is no longer visible. This is typically after the duration of the ad or the displayed content.
When this event triggers, animations should either stop, reverse, or reset. Elements should be cleaned up by either removing them from the DOM or resetting them to their initial states. If they aren’t cleaned up, the div containing the dynamic creative will disappear 500 milliseconds later.

